/*
   This program creates two child processes and then builds
   a two stage pipeline out of those two processes. This
   parent process is not part of the pipeline. It does not
   share in any of the work done in the pipeline.

   To build the pipeline, the parent starts each of the child
   processes, then it makes the first child inherit the parent's
   stdin, then it makes the second child inherit the parent's
   stdout, then it redirects the first child's stdout to the
   second child's stdin. The parent should end up sharing stdin
   with the first child and stdout with the second child, but
   the parent should make no use of stdin and stdout while its
   children are running.


   Important: Notice that this program is logically
   the same as the following command line pipe.

   C:\> java RemoveVowels | java ToUpperCase

   In the case of the above command line, the shell
   program (cmd.exe) sets up the pipeline before running
   the two programs RemoveVowels.class and ToUpperCase.class.
   In the case of this program, the program itself creates
   the pipeline between the two child processes. So this
   program is acting like a very simple shell program.
*/
import java.util.Scanner;
import java.io.*;

public class Java6_Pipeline_ver3
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the stage1 child.
      String cmd1 = "java RemoveVowels";
           //cmd1 = "java RemoveVowelsDelayed";  // or use this "delayed" version of the filter
      // Execute the first filter.
      Process process1 = Runtime.getRuntime().exec(cmd1);

      // Create a command line for running the stage2 child.
      String cmd2 = "java ToUpperCase";
           //cmd2 = "java ToUpperCaseDelayed";   // or use this "delayed" version of the filter
      // Execute the second filter.
      Process process2 = Runtime.getRuntime().exec(cmd2);


      // Get references to the streams for sending input into each stage.
      final PrintStream stage1In = new PrintStream( process1.getOutputStream() );
      final PrintStream stage2In = new PrintStream( process2.getOutputStream() );

      // Get references to the streams for reading output from each stage.
      final Scanner stage1Out = new Scanner( process1.getInputStream() );
      final Scanner stage2Out = new Scanner( process2.getInputStream() );

      // Create a Scanner object to make it easier to use System.in
      final Scanner scanner = new Scanner( System.in );


      // Create a "pump" between stdin and the first stage
      new Thread(new Runnable(){public void run()
      {while ( scanner.hasNextLine() )
       {String oneLine = scanner.nextLine();  // read from stdin
        stage1In.println( oneLine );          // write to first stage
        //stage1In.flush();
      }stage1In.close();  // THIS IS IMPORTANT (without it process1 hangs)
      }}).start();


      // Create a "pump" between the first stage and the second stage.
      new Thread(new Runnable(){public void run()
      {while(stage1Out.hasNextLine())
       {String oneLine = stage1Out.nextLine();  // read from first stage
        stage2In.println( oneLine );            // write to second stage
        //stage2In.flush();
       }stage2In.close(); //THIS IS IMPORTANT (without it process2 hangs)
      }}).start();


      // Create a "pump" between the second stage and stdout.
      new Thread(new Runnable(){public void run()
      {while (stage2Out.hasNextLine())
       {String oneLine = stage2Out.nextLine();  // read from second stage
        System.out.println( oneLine );          // write to stdout
       }}}).start();


      // Wait for the second child to finish its work.
      process2.waitFor();  // this throws InterruptedException
   }
}